# spamassassin plugin for manitou-mail

package Manitou::Plugins::spamc;

sub init {
  my $dbh=shift;
  my ($args)=@_;
  my $self={};
  bless $self;
  # The plugin argument can be either a string (name of a tag)
  # or a reference to a hash: { tag=>name of tag, status=>trashed }
  if (defined $args) {
    if (ref($args) eq "HASH") {
      $self->{spamtag}=$args->{tag} if (defined $args->{tag});
      $self->{status}="trashed" if ($args->{status} eq "trashed");
    }
    else { $self->{spamtag}=$args; }
  }
  return $self;
}

sub finish {
  # nothing to do
  1;
}

sub process {
  my ($self,$ctxt)=@_;
  if ((defined $self->{spamtag} || defined $self->{status})
      && defined($ctxt->{'filename'})) {
    my $r=`spamc -c < $ctxt->{filename}`;
    if ($?==256 && $r =~ /\//) {	# if spamc says the message is spam
      if (defined $self->{spamtag}) {
	push @{$ctxt->{tags}}, $self->{spamtag}; # then add the relevant tag
      }
      if ($self->{status} eq "trashed") {
	$ctxt->{status} |= 16+32;  # trashed+processed
      }
    }
  }
  1;
}

1;
